\connect pcweek;
set datestyle to 'US';

-- delete contents of updates table
delete from updates;

-- load data into updates table
select 'starting updates data load' as message, time(CURRENT_TIMESTAMP) as time;

-- load updates
copy updates from '/dbimportdata/updates.dat' using delimiters ',';

-- recalc stats
vacuum analyze updates;

-- check size of table
select count(*) from updates;

-- finished data load
select 'finished updates data load' as message, time(CURRENT_TIMESTAMP) as time;

-- deleting contents of check tables
delete from update_int_history;
delete from update_signed_history;

\q
